<?php include 'header-link.php' ?>
<?php 
 
// Check if ID is provided in the URL
if (!isset($_GET['id'])) {
    header("Location: index.php"); // Redirect if no ID is provided
    exit();
}

$id = $_GET['id'];

// Retrieve existing data from mobile_banking table
$sqlRetrieve = "SELECT * FROM mobile_banking WHERE id = ?";
$stmtRetrieve = $con->prepare($sqlRetrieve);

if ($stmtRetrieve === false) {
    die('Prepare failed: ' . htmlspecialchars($con->error));
}

$stmtRetrieve->bind_param("i", $id);
$stmtRetrieve->execute();
$result = $stmtRetrieve->get_result();
$row = $result->fetch_assoc();

$stmtRetrieve->close();

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $gateway = $_POST['gateway'];
    $trans_type = $_POST['trans_type'];
    $mobile = $_POST['mobile'];
    $amount = $_POST['amount'];
    $adminNum = $_POST['adminNum'];
    $status = $_POST['status'];

    // Update the status in the mobile_banking table
    $sqlUpdate = "UPDATE mobile_banking SET gateway = ?, trans_type = ?, mobile = ?, amount = ?, status = ? WHERE id = ?";
    $stmtUpdate = $con->prepare($sqlUpdate);

    if ($stmtUpdate === false) {
        die('Prepare failed: ' . htmlspecialchars($con->error));
    }

    $stmtUpdate->bind_param("sssssi", $gateway, $trans_type, $mobile, $amount, $status, $id);

    if ($stmtUpdate->execute()) {
        // If status is accepted, deduct the amount from user's balance
        if ($status === 'Accepted') {
            // Retrieve the user ID associated with this transaction
            $userid = $row['userid']; // Assuming the userid is stored in the mobile_banking table

            // Deduct the amount from user's balance
            $sqlDeductBalance = "UPDATE balance SET amount = amount - ? WHERE userid = ?";
            $stmtDeductBalance = $con->prepare($sqlDeductBalance);

            if ($stmtDeductBalance === false) {
                die('Prepare failed: ' . htmlspecialchars($con->error));
            }

            $stmtDeductBalance->bind_param("di", $amount, $userid);

            if (!$stmtDeductBalance->execute()) {
                $_SESSION['message'] = "Failed to update balance.";
            }

            $stmtDeductBalance->close();

            // Insert notification for accepted status
            $message = 'এডমিন  আপনার মোবাইল ব্যাংকিং  রিকোয়েস্টটি   গ্রহণ ও সম্পন্ন করেছেন'.' - ' .$adminNum;
            $notificationStatus = 'Unread';
            $date = date('Y-m-d'); // Get current date and time

            $sqlInsertNotification = "INSERT INTO notification (userid, message, status, date) VALUES (?, ?, ?, ?)";
            $stmtInsertNotification = $con->prepare($sqlInsertNotification);

            if ($stmtInsertNotification === false) {
                die('Prepare failed: ' . htmlspecialchars($con->error));
            }

            $stmtInsertNotification->bind_param("isss", $userid, $message, $notificationStatus, $date);
            $stmtInsertNotification->execute();
            $stmtInsertNotification->close();
        } elseif ($status === 'Rejected') {
            // Insert notification for rejected status
            $userid = $row['userid']; // Assuming the userid is stored in the mobile_banking table
            $message = ' এডমিন  আপনার মোবাইল ব্যাংকিং রিকোয়েস্টটি   বাতিল করেছেন ';
            $notificationStatus = 'Unread';
            $date = date('Y-m-d'); // Get current date and time

            $sqlInsertNotification = "INSERT INTO notification (userid, message, status, date)
												VALUES (?, ?, ?, ?)";
            $stmtInsertNotification = $con->prepare($sqlInsertNotification);

            if ($stmtInsertNotification === false) {
                die('Prepare failed: ' . htmlspecialchars($con->error));
            }

            $stmtInsertNotification->bind_param("isss", $userid, $message, $notificationStatus, $date);
            $stmtInsertNotification->execute();
            $stmtInsertNotification->close();
        }
        
        $_SESSION['message'] = "Update successful.";
    } else {
        $_SESSION['message'] = "Error updating record.";
    }

    $stmtUpdate->close();
    header("Location: mobile-banking-request.php");
    exit();
}
?>


    <main>
	
        <section>   
			<div class="container mb-5">
				<div class="row justify-content-center">
					<div class="col-md-6">
						<div class="card custom-card">
							<div class="card-body">
								<h6 class="card-title text-center d-block"> Update Request </h6>
                                       
                                           
								
									<form class="form" action="" method="POST">

                                        <div class="mb-3">
                                            <label class="form-label"> Gateway </label>
                                                <input type="text" name="gateway" class="form-control" value="<?php echo htmlspecialchars($row['gateway']); ?>" required>
                                                                                      
										</div>

                                        <div class="mb-3">
                                            <label class="form-label"> Transaction Type </label>
                                                <input type="text" name="trans_type" class="form-control" value="<?php echo htmlspecialchars($row['trans_type']); ?>" required>
                                           
										</div>

                                        <div class="mb-3">
                                            <label class="form-label"> Mobile No </label>
                                                <input type="text" name="mobile" class="form-control" value="<?php echo htmlspecialchars($row['mobile']); ?>" required>
                                         
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label"> Amount </label>
                                                <input type="text" name="amount" class="form-control" value="<?php echo htmlspecialchars($row['amount']); ?>" required>
                                           
                                        </div>
										
										
										 <div class="mb-3">
                                            <label class="form-label"> Admin Number </label>
                                                <input type="text" name="adminNum" class="form-control" placeholder="Admin Bkash/Nagad">
                                           
                                        </div>
                                      
                                      


										<div class="mb-3">
                                            <label class="form-label"> Choose Status </label>
                                                <select name="status" class="form-select    form-control" required>
                                                    <option value="Pending" <?php echo $row['status'] === 'Pending' ? 'selected' : ''; ?>>Pending</option>
                                                    <option value="Accepted" <?php echo $row['status'] === 'Accepted' ? 'selected' : ''; ?>>Accepted</option>
													<option value="Rejected" <?php echo $row['status'] === 'Rejected' ? 'selected' : ''; ?>>Rejected</option>
                                                </select>
										</div>

										<button type="submit" class="btn custom-button"> Save  </button>
									</form>
									
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		

		
    </main>

    
</body>
</html>
